
/**
 *      Much of the FTP routines was inspired by the nanoftp.c module from
 *      libxml2 (Copyright Daniel Veillard, 2003).  The routines have been
 *      modified to fit the needs of the Motion project.
 *
 *      Copyright 2005, William M. Brack
 *      This software is distributed under the GNU Public license Version 2.
 *      See also the file 'COPYING'.
 *      
 */
#ifndef	_INCLUDE_NETCAM_FTP_H
#define	_INCLUDE_NETCAM_FTP_H

#define	FTP_BUF_SIZE    1024

typedef struct ftpCtxt {
    char      *path;            /* the path within the URL */
    char      *user;            /* user string */
    char      *passwd;          /* passwd string */
    struct sockaddr_in ftpAddr; /* the socket addr structure */
    int       passive;          /* flag show passive/active mode used */
    int       controlFd;        /* file descriptor for the control socket */
    int       dataFd;           /* file descriptor for the data socket */
    int       state;            /* WRITE / READ / CLOSED */
    int       returnValue;      /* the protocol return value */
    /* buffer for data received from the control connection */
    char      controlBuf[FTP_BUF_SIZE + 1];
    int       controlBufIndex;
    int       controlBufUsed;
    int       controlBufAnswer;
} ftpCtxt, *ftpCtxtPtr;

/* The public interface */
ftpCtxtPtr ftpNewCtxt(void);
void ftpFreeCtxt(ftpCtxtPtr);
ftpCtxtPtr ftpOpen(const char *);
int ftpConnect(netcam_context_ptr);
int ftpSendType(ftpCtxtPtr, const char);
int ftpGetSocket(ftpCtxtPtr);
int ftpRead(ftpCtxtPtr, void *, int);
int ftpClose(ftpCtxtPtr);
#endif
