#ifndef _INCLUDE_ROTATE_H
#define _INCLUDE_ROTATE_H

#include "motion.h"

/* Sets up rotation data:
 * - Allocates temporary buffer for 90/270 degrees rotation.
 * - Determines the right rotate-180-degrees function.
 */
void rotate_init(struct context *cnt);

/* Frees memory allocated by rotate_init. */
void rotate_deinit(struct context *cnt);

/* Rotates the image stored in map according to the rotation data
 * available in cnt. Rotation is performed clockwise. Supports 90,
 * 180 and 270 degrees rotation. 180 degrees rotation is performed
 * in-place by simply reversing the image data, which is a very
 * fast operation. 90 and 270 degrees rotation are performed using
 * a temporary buffer and a somewhat more complicated algorithm,
 * which makes them slower.
 *
 * Returns 0 on success, 1 on failure.
 */
int rotate_map(unsigned char *map, struct context *cnt);

#endif
