/*	motion.h
 *
 *	Include file for motion.c
 *      Copyright 2000 by Jeroen Vreeken (pe1rxq@amsat.org)
 *      This software is distributed under the GNU public license version 2
 *      See also the file 'COPYING'.
 *
 */

#ifndef _INCLUDE_MOTION_H
#define _INCLUDE_MOTION_H

/* Includes */
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#define __USE_GNU
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <signal.h>
#include <syslog.h>
#include <limits.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#define _LINUX_TIME_H 1
#if (!defined(WITHOUT_V4L)) && (!defined (__freebsd__))
#include <linux/videodev.h>
#endif

#include <pthread.h>

#ifdef HAVE_MYSQL
#include <mysql.h>
#endif

#ifdef HAVE_PGSQL
#include <libpq-fe.h>
#endif

#include "conf.h"
#include "webcam.h"
#include "webhttpd.h"

#if defined(WITHOUT_V4L) || defined(__freebsd__)
 
#define VIDEO_PALETTE_GREY      1       /* Linear greyscale */
#define VIDEO_PALETTE_HI240     2       /* High 240 cube (BT848) */
#define VIDEO_PALETTE_RGB565    3       /* 565 16 bit RGB */
#define VIDEO_PALETTE_RGB24     4       /* 24bit RGB */
#define VIDEO_PALETTE_RGB32     5       /* 32bit RGB */
#define VIDEO_PALETTE_RGB555    6       /* 555 15bit RGB */
#define VIDEO_PALETTE_YUV422    7       /* YUV422 capture */
#define VIDEO_PALETTE_YUYV      8
#define VIDEO_PALETTE_UYVY      9       /* The great thing about standards is ... */
#define VIDEO_PALETTE_YUV420    10
#define VIDEO_PALETTE_YUV411    11      /* YUV411 capture */
#define VIDEO_PALETTE_RAW       12      /* RAW capture (BT848) */
#define VIDEO_PALETTE_YUV422P   13      /* YUV 4:2:2 Planar */
#define VIDEO_PALETTE_YUV411P   14      /* YUV 4:1:1 Planar */
#define VIDEO_PALETTE_YUV420P   15      /* YUV 4:2:0 Planar */
#define VIDEO_PALETTE_YUV410P   16      /* YUV 4:1:0 Planar */
#define VIDEO_PALETTE_PLANAR    13      /* start of planar entries */
#define VIDEO_PALETTE_COMPONENT 7       /* start of component entries */
#endif

/* Default picture settings */
#define DEF_WIDTH              352
#define DEF_HEIGHT             288
#define DEF_QUALITY             75
#define DEF_CHANGES           1500

#define DEF_MAXFRAMERATE       100
#define DEF_NOISELEVEL          32

/* Minimum time between two 'actions' (email, sms, external) */
#define DEF_GAP                 60  /* 1 minutes */
#define DEF_MAXMPEGTIME       3600  /* 60 minutes */

#define DEF_FFMPEG_BPS      400000
#define DEF_FFMPEG_VBR           0
#define DEF_FFMPEG_CODEC   "mpeg4"

#define THRESHOLD_TUNE_LENGTH  256

#define DEF_MAXSTREAMS          10  /* Maximum number of webcam clients per camera */
#define DEF_MAXWEBQUEUE         10  /* Maximum number of webcam client in queue */

#define DEF_TIMESTAMP      "%Y-%m-%d\\n%T"

#define DEF_SNAPPATH       "%v-%Y%m%d%H%M%S-snapshot"
#define DEF_JPEGPATH       "%v-%Y%m%d%H%M%S-%q"
#define DEF_MPEGPATH       "%v-%Y%m%d%H%M%S"
#define DEF_TIMEPATH       "%Y%m%d-timelapse"

#define DEF_TIMELAPSE_MODE "daily"

/* Filetype defines */
#define FTYPE_IMAGE            1
#define FTYPE_IMAGE_SNAPSHOT   2
#define FTYPE_IMAGE_MOTION     4
#define FTYPE_MPEG             8
#define FTYPE_MPEG_MOTION     16
#define FTYPE_MPEG_TIMELAPSE  32

#define FTYPE_MPEG_ANY    (FTYPE_MPEG | FTYPE_MPEG_MOTION | FTYPE_MPEG_TIMELAPSE)
#define FTYPE_IMAGE_ANY   (FTYPE_IMAGE | FTYPE_IMAGE_SNAPSHOT | FTYPE_IMAGE_MOTION)

#define NEWIMG_OFF       0
#define NEWIMG_ON        1
#define NEWIMG_FIRST     2
#define NEWIMG_BEST      3

#define LOCATE_OFF       0
#define LOCATE_ON        1
#define LOCATE_PREVIEW   2

#define LOCATE_NORMAL    0
#define LOCATE_BOTH      1

/* DIFFERENCES BETWEEN imgs.width, conf.width AND rotate_data.cap_width
 * (and the corresponding height values, of course)
 * ===========================================================================
 * Location      Purpose
 * 
 * conf          The values in conf reflect width and height set in the
 *               configuration file. These can be set via xmlrpc, but they are
 *               not used internally by Motion, so it won't break anything.
 *               These values are transferred to imgs in vid_start.
 *
 * imgs          The values in imgs are the actual output dimensions. Normally
 *               the output dimensions are the same as the capture dimensions,
 *               but for 90 or 270 degrees rotation, they are not. E.g., if 
 *               you capture at 320x240, and rotate 90 degrees, the output
 *               dimensions are 240x320.
 *               These values are set from the conf values in vid_start, or 
 *               from the first JPEG image in netcam_start. For 90 or 270 
 *               degrees rotation, they are swapped in rotate_init.
 *
 * rotate_data   The values in rotate_data are named cap_width and cap_height,
 *               and contain the capture dimensions. The difference between
 *               capture and output dimensions is explained above.
 *               These values are set in rotate_init.
 */

/* date/time drawing, draw.c */
int draw_text (unsigned char *image, int startx, int starty, int height, int width, char *text);

struct images {
	unsigned char *new;
	unsigned char *ref;
	unsigned char *out;
	unsigned char *preview_buffer;
	unsigned char *mask;
	unsigned char *smartmask;
	unsigned char *smartmask_final;
	unsigned char *common_buffer;
	int *smartmask_buffer;
	int *labels;
	int *labelsize;
	int width;
	int height;
	int type;
	int size;
	int motionsize;
	int total_labels;
	int labelsize_max;
	int labelgroup_max;
	int labels_above;
	int largest_label;
	time_t *timestamp;
	int *shotstamp;
};

/* Contains data for image rotation, see rotate.c. */
struct rotdata {
	/* Temporary buffer for 90 and 270 degrees rotation. */
	unsigned char *temp_buf;
	/* Pointer to a rotate-180-degrees function. */
	void (*rotate_180)(unsigned char *, int);
	/* Degrees to rotate; copied from conf.rotate_deg. This is the value
	 * that is actually used. The value of conf.rotate_deg cannot be used
	 * because it can be changed by motion-control, and changing rotation
	 * while Motion is running just causes problems.
	 */
	int degrees;
	/* Capture width and height - different from output width and height if 
	 * rotating 90 or 270 degrees. */
	int cap_width;
	int cap_height;
};

#include "track.h"

#include "netcam_wget.h"

struct url_t {
	char *service;
	char *userpass;
	char *host;
	int port;
	char *path;
};

struct netcam_context {
	pthread_t thread;
	pthread_attr_t thread_attr;
	pthread_mutex_t mutex;
	int threadnr;
	int state;
	struct rbuf *response;
	struct url_t url;
	char *userpass;
	char *boundary;
	struct netcam_caps {		/* netcam capabilities: */
		int streaming;		/*  1 - supported       */ 
		int contentlength;	/*  0 - unsupported     */
	} caps;
	int which;
	pthread_cond_t which_cond;
	pthread_cond_t dirty_cond;
	struct netcam_image {
		pthread_mutex_t mutex;
		struct netcam_image_buffer {
			char *ptr;
			size_t size;
			size_t used;
			int dirty;
		} buffer;
	} image[2];
	int (*read)(struct context *);
};


/*
	these used to be global variables but now each thread will have its
	own context
 */
struct context {
	char conf_filename[PATH_MAX];
	int threadnr;
	int daemon;

	struct config conf;
	struct images imgs;
	struct trackoptions track;
	struct netcam_context *netcam;
	int precap_nr;
	int precap_cur;
	int new_img;
	int preview_shot;
	int preview_max;
	int locate;
	struct coord location;      /* coordinates for center and size of last motion detection*/
	struct rotdata rotate_data; /* rotation data is thread-specific */

	int diffs;
	int noise;
	int threshold;
	int diffs_last[THRESHOLD_TUNE_LENGTH];
	int smartmask_speed;

	int snapshot;
	int makemovie;
	int finish;

	int event_nr;
	int prev_event;

	int shots;
	struct tm *currenttime;
	time_t currenttimep;
	time_t lasttime;
	time_t eventtime;
	time_t lastshot;

	int lastrate;
	int moved;
	int switched;
	int pause;
#ifdef __freebsd__
	int tuner_dev;
#endif
	int video_dev;
	int pipe;
	int mpipe;

	struct webcam webcam;
	int stream_count;
	
#if defined(HAVE_MYSQL) || defined(HAVE_PGSQL)
	int sql_mask;
#endif

#ifdef HAVE_MYSQL
	MYSQL *database;
#endif

#ifdef HAVE_PGSQL
	PGconn *database_pg;
#endif

#ifdef HAVE_FFMPEG
	struct ffmpeg *ffmpeg_new;
	struct ffmpeg *ffmpeg_motion;
	struct ffmpeg *ffmpeg_timelapse;
	struct ffmpeg *ffmpeg_smartmask;
	char newfilename[255];
	char motionfilename[255];
	char timelapsefilename[255];
#endif
};

extern int threads_running;

void myperror(char *format, ...);
int http_bindsock(int, int, struct context *);
void * mymalloc(size_t size);
void * myrealloc(void *ptr, size_t size, char *desc);
FILE * myfopen(char *path, char *mode);
size_t mystrftime(char *s, size_t max, char *userformat,
                  const struct tm *tm, struct context *);
int create_path(char *);

#endif /* _INCLUDE_MOTION_H */
