#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "motion.h"
#include "conf.h"
#include "webhttpd.h"
#include "netcam_wget.h"

pthread_mutex_t httpd_mutex;

extern config_param config_params[];

extern int errno;

static char* ini_template =
	"<html><head></head>\n"
	"<body>\n";

static char *set_template =
	"<html><head><script language='javascript'>"
	"function show(){top.location.href="
	"'set?'+document.n.onames.options[document.n.onames.selectedIndex].value"
	"+'='+document.s.valor.value;"
	"}</script></head>\n"
	"<body>\n";

static char* end_template =
	"</body>\n"
	"</html>\n";

static char* ok_response =
	"HTTP/1.1 200 OK\n"
	"Server: Motion-httpd/"VERSION"\n"
	"Connection: close\n"
	"Max-Age: 0\n"
	"Expires: 0\n"
	"Cache-Control: no-cache\n"
	"Cache-Control: private\n"
	"Pragma: no-cache\n"
	"Content-type: text/html\n\n";

static char* ok_response_raw =
	"HTTP/1.1 200 OK\n"
	"Server: Motion-httpd/"VERSION"\n"
	"Connection: close\n"
	"Max-Age: 0\n"
	"Expires: 0\n"
	"Cache-Control: no-cache\n"
	"Cache-Control: private\n"
	"Pragma: no-cache\n"
	"Content-type: text/plain\n\n";


static char* bad_request_response =
	"HTTP/1.0 400 Bad Request\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Bad Request</h1>\n"
	"<p>The server did not understand your request.</p>\n"
	"</body>\n"
	"</html>\n";

static char* bad_request_response_raw =
	"HTTP/1.0 400 Bad Request\n"
	"Content-type: text/plain\n\n"
	"Bad Request";
	
static char* not_found_response_template =
	"HTTP/1.0 404 Not Found\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Not Found</h1>\n"
	"<p>The requested URL was not found on the server.</p>\n"
	"</body>\n"
	"</html>\n";

static char* not_found_response_template_raw =
	"HTTP/1.0 404 Not Found\n"
	"Content-type: text/plain\n\n"
	"Not Found";
	
static char* not_found_response_valid =
	"HTTP/1.0 404 Not Valid\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Not Valid</h1>\n"
	"<p>The requested URL is not valid.</p>\n"
	"</body>\n"
	"</html>\n";

static char* not_found_response_valid_raw =
	"HTTP/1.0 404 Not Valid\n"
	"Content-type: text/plain\n\n"
	"The requested URL is not valid.";
	
static char* not_valid_sintax =
	"HTTP/1.0 404 Not Valid Syntax\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Not Valid Sintax</h1>\n"
	"</body>\n"
	"</html>\n";

static char* not_valid_sintax_raw =
	"HTTP/1.0 404 Not Valid Syntax\n"
	"Content-type: text/plain\n\n"
	"Not Valid Sintax\n";
	
static char* not_track =
	"HTTP/1.0 404 Not Track Enable\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Not Track Enable</h1>\n";

static char* not_track_raw =
	"HTTP/1.0 404 Not Track Enable\n"
	"Content-type: text/plain\n\n"
	"Not Track Enable";

static char* track_error =
	"HTTP/1.0 404 Track Error\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Track Error</h1>\n";

static char* track_error_raw =
	"HTTP/1.0 404 Track Error\n"
	"Content-type: text/plain\n\n"
	"Track Error";

static char* not_found_response_valid_command =
	"HTTP/1.0 404 Not Valid Command\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Not Valid Command</h1>\n"
	"<p>The requested URL is not valid Command.</p>\n"
	"</body>\n"
	"</html>\n";

static char* not_found_response_valid_command_raw =
	"HTTP/1.0 404 Not Valid Command\n"
	"Content-type: text/plain\n\n"
	"Not Valid Command\n";
	
static char* bad_method_response_template =
	"HTTP/1.0 501 Method Not Implemented\n"
	"Content-type: text/html\n\n"
	"<html>\n"
	"<body>\n"
	"<h1>Method Not Implemented</h1>\n"
	"<p>The method is not implemented by this server.</p>\n"
	"</body>\n"
	"</html>\n";

static char* bad_method_response_template_raw =
	"HTTP/1.0 501 Method Not Implemented\n"
	"Content-type: text/plain\n\n"
	"Method Not Implemented\n";

static char *request_auth_response_template=
	"HTTP/1.0 401 Authorization Required\n"
	"WWW-Authenticate: Basic realm=\"Motion Security Access\"\n";
	
int send_template_ini_client(int client_socket, const char* template)
{
	int nwrite=0;
	nwrite = write (client_socket, ok_response, strlen (ok_response));
	nwrite += write (client_socket,template,strlen(template));
	if (nwrite != (strlen (ok_response)+strlen(template))) {
		printf("http thread: send_template_ini_client failure write\n");
	}
	return nwrite;
}

int send_template_ini_client_raw(int client_socket)
{
	int nwrite=0;
	nwrite = write (client_socket, ok_response_raw, strlen (ok_response_raw));
	if (nwrite != strlen (ok_response_raw)) {
		printf("http thread: send_template_ini_client_raw failure write\n");
	}
	return nwrite;
}


int send_template_client(int client_socket,char *name,char* res)
{
	int nwrite=0;
	nwrite = write (client_socket,name,strlen(name));
	nwrite += write (client_socket,": ",2);
	nwrite += write (client_socket,res,strlen(res));
	nwrite += write (client_socket,"<br>",4);
	
	if (nwrite != (strlen (name) + strlen(res) + 6) ) {
		printf("http thread: send_template_client failure write\n");
	}
	return nwrite;
}

int send_template(int client_socket, char *res)
{
	int nwrite=0;
	nwrite = write (client_socket,res,strlen(res));
	nwrite += write (client_socket,"<br>",4);
	if (nwrite != (strlen(res) + 4) ) {
		printf("http thread: send_template failure write\n");
	}
	return nwrite; 
}

int send_template_raw(int client_socket, char *res)
{
	int nwrite=0;
	nwrite = write (client_socket,res,strlen(res));
	return nwrite; 
}

int send_template_end_client(int client_socket)
{
	int nwrite=0;
	nwrite = write (client_socket,end_template,strlen(end_template));
	return nwrite;
}

int response_client(int client_socket, const char* template,char *back)
{
	int nwrite=0;
	nwrite = write (client_socket, template , strlen(template));
	if (back != NULL){
		send_template(client_socket,back);
		send_template_end_client(client_socket);
	}
	return nwrite;
}


int check_authentication(char *authentication, char *auth_base64,size_t size_auth , char * conf_auth)
{
	int ret=0;
	char *userpass = NULL;
	
	authentication = (char *) mymalloc(BASE64_LENGTH(size_auth) + 1);
	userpass = mymalloc(size_auth + 4);
	/* base64_encode can read 3 bytes after the end of the string, initialize it */
	memset(userpass, 0, size_auth + 4);
	strcpy(userpass, conf_auth);
	base64_encode(userpass, authentication, size_auth);
	free(userpass);
	
	if (!strcmp(authentication,auth_base64)) ret=1;
	return ret;
}	
	 
		 

/*
   This function decode the values from GET request following the http RFC.
*/

int url_decode(char *urlencoded,int lenght)
{
	char *data=urlencoded;
	char *urldecoded=urlencoded;
	
	while (lenght > 0){
		if (*data == '%'){
			char c[3];
			int i;
			data++;lenght--;
			c[0] = *data++;
			lenght--;
			c[1] = *data;
			c[2] = 0;
			sscanf(c, "%x", &i);
			if (i < 128) *urldecoded++ = (char)i;
			else {
				*urldecoded++ = '%';
				*urldecoded++ = c[0];
				*urldecoded++ = c[1];
			}
		}else if(*data=='+'){
			*urldecoded++=' ';
			
		}
		else{
			*urldecoded++=*data;
		}
		data++;
		lenght--;
	}
	*urldecoded = '\0';
	return 0;
}


/*
    This function manages/parses the config action for motion ( set , get , write , list ).
*/
 
int config(char *pointer,char *res,int lenght_uri,int thread,int client_socket,void *userdata)
{
	char question;	
	char *command=NULL;	
	int i;
	struct context **cnt=userdata;		
		
	sscanf (pointer, "%a[a-z]%c" , &command , &question);
	if (!strcmp(command,"list")){
		pointer=pointer+4;lenght_uri=lenght_uri-4;
		if (lenght_uri==0){
			char *value=NULL;
			/*call list*/
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,ini_template);
			sprintf(res,"<a href=/%d/config><- back</a>",thread);
			send_template(client_socket,res);
			for (i=0; config_params[i].param_name != NULL; i++) {
				value=config_params[i].print(cnt, NULL, i, thread);
				if (value == NULL) value=config_params[i].print(cnt, NULL, i, 0);
				sprintf(res,"<li><a href=/%d/config/set?%s>%s</a> = %s</li>",thread,
					config_params[i].param_name,config_params[i].param_name,value);
				send_template(client_socket,res);
			}
			sprintf(res,"<a href=/%d/config><- back</a>",thread);
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				for (i=0; config_params[i].param_name != NULL; i++) {
				value=config_params[i].print(cnt, NULL, i, thread);
				if (value == NULL) value=config_params[i].print(cnt, NULL, i, 0);
				sprintf(res,"%s = %s\n",config_params[i].param_name,value);
				send_template_raw(client_socket,res);
				} 	
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);

			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"set")){
		/* set?param_name=value */
		pointer=pointer+3;lenght_uri=lenght_uri-3;
		if ((lenght_uri!=0) && (question == '?')){
			pointer++;lenght_uri--;
			sscanf(pointer,"%a[a-z_]%c",&command,&question);
			/*check command , question == '='  lenght_uri too*/
			if ((question == '=') && (command!=NULL)){
				lenght_uri = lenght_uri - strlen(command) - 1;
				pointer = pointer + strlen(command) + 1;
				/* check if command exists and type of command and not end of URI */
				i=0;
				while (config_params[i].param_name != NULL) {
					if (!strcasecmp(command, config_params[i].param_name))
						break;
						i++;
				}
									
				if (config_params[i].param_name){
					if (lenght_uri > 0){
						char Value[256];
						sscanf(pointer,"%s",Value);
						lenght_uri = lenght_uri - strlen(Value);
						if ( (lenght_uri==0) && (strlen(Value) > 0) ){
							/* FIXME need to asure that is a valid value */
							url_decode(Value,strlen(Value));
							conf_cmdparse(cnt+thread, config_params[i].param_name, Value);	
							if (cnt[0]->conf.control_html_output){
							sprintf(res,"<li><a href=/%d/config/set?%s>%s</a> = %s</li> <b>Done</b>",thread,
								config_params[i].param_name,config_params[i].param_name,Value);
							send_template_ini_client(client_socket,ini_template);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/list><- back</a>",thread);
							send_template(client_socket,res);	
							send_template_end_client(client_socket);
							}else{
							send_template_ini_client_raw(client_socket);
							sprintf(res,"%s = %s Done\n",config_params[i].param_name,Value);
							send_template_raw(client_socket,res);
							}
						}else{
							/*error*/
							if (cnt[0]->conf.control_html_output)
								response_client(client_socket,not_valid_sintax,NULL);
							else response_client(client_socket,not_valid_sintax_raw,NULL);
						}
					}else{
						char *type=NULL; 
						type = strdup(config_type(&config_params[i]));
						
						if (!strcmp(type,"string")){
							char value[1]={'\0'};
							conf_cmdparse(cnt+thread, config_params[i].param_name, value);
							free(type);
							type = strdup("(null)");
						}else if (!strcmp(type,"int")){
							free(type);
							type = strdup("0");
							conf_cmdparse(cnt+thread, config_params[i].param_name, type);
						}else if (!strcmp(type,"bool")){
							free(type);
							type = strdup("off");
							conf_cmdparse(cnt+thread, config_params[i].param_name, type);
						}else{
							// FIXME
							free(type);
							type = strdup("unknow");
						}
						
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<li><a href=/%d/config/set?%s>%s</a> = %s</li> <b>Done</b>",thread,config_params[i].param_name,config_params[i].param_name,type);
							send_template_ini_client(client_socket,ini_template);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/list><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
						}else{
							send_template_ini_client_raw(client_socket);
							sprintf(res,"%s = %s Done\n",config_params[i].param_name,type);
							send_template_raw(client_socket,res);
						}
						free(type);
						
					}						   
				}else{
					/*error*/
					if (cnt[0]->conf.control_html_output){
						response_client(client_socket,not_found_response_valid_command,NULL);
					}	
					else response_client(client_socket,not_found_response_valid_command_raw,NULL);
				}
			}else{
				/* Show param_name dialogue only for html output */
				if ( (cnt[0]->conf.control_html_output) && (command!=NULL) && 
					(((lenght_uri = lenght_uri - strlen(command)) == 0 )) ){
					i=0;
					while (config_params[i].param_name != NULL) {
						if (!strcasecmp(command, config_params[i].param_name))
							break;
						i++;
					}
					/* param_name exists */
					if (config_params[i].param_name){
						send_template_ini_client(client_socket,ini_template);
						sprintf(res,"<b>Thread %d </b><form action=set?>",thread);
						send_template(client_socket,res);
						sprintf(res,"<b>%s</b>&nbsp;<input type=text name='%s' value=''><input type='submit' value='set'>",config_params[i].param_name,config_params[i].param_name);
						send_template(client_socket,res);
						sprintf(res,"</form><a href=/%d/config/list><- back</a>",thread);
						send_template(client_socket,res);
						send_template_end_client(client_socket);
					}else{
						if (cnt[0]->conf.control_html_output){
							response_client(client_socket,not_found_response_valid_command,NULL);
						}	
						else response_client(client_socket,not_found_response_valid_command_raw,NULL);
					}
				}else{	
				if (cnt[0]->conf.control_html_output){
					response_client(client_socket,not_found_response_valid_command,NULL);
				}	
				else response_client(client_socket,not_found_response_valid_command_raw,NULL);
				}	
			}
		}else if(lenght_uri == 0){
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,set_template);
			sprintf(res,"<b>Thread %d </b><form name='n'><select name='onames'>",thread);
			send_template(client_socket,res);
			for (i=0; config_params[i].param_name != NULL; i++) {
				sprintf(res,"<option value='%s'>%s</option>",config_params[i].param_name,config_params[i].param_name);
				send_template(client_socket,res);
			}
			sprintf(res,"</select></form>");
			send_template(client_socket,res);
			sprintf(res,"<form action=set name='s'>");
			send_template(client_socket,res);
			sprintf(res,"<input type=text name='valor' value=''><input type='button' value='set' onclick='javascript:show()'>");
			send_template(client_socket,res);
			
			sprintf(res,"</form><a href=/%d/config><- back</a>",thread);
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			sprintf(res,"set needs param_name=value\n");
			send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}			
	}else if (!strcmp(command,"get")){
		/* get?query=param_name */
		pointer=pointer+3;lenght_uri=lenght_uri-3;
		if ((lenght_uri > 7) && (question == '?')){
			/* 8 -> query=param_name FIXME minimun length param_name */
			pointer++;lenght_uri--;
			sscanf(pointer,"%a[a-z]%c",&command,&question);
			if ( (question == '=') && (!strcmp(command,"query")) ){
				pointer = pointer + 6;lenght_uri = lenght_uri - 6;
				sscanf(pointer,"%a[a-z_]",&command);
				/*check if command exist, lenght_uri too*/
				lenght_uri = lenght_uri-strlen(command);
				if (lenght_uri == 0){
					char *value=NULL;
					i=0;
					//printf("get %s\n",command);
					while (config_params[i].param_name != NULL) {
						if (!strcasecmp(command, config_params[i].param_name))
							break;
							i++;
					}
					/* FIXME bool values or commented values maybe that should be
					solved with config_type */
					
					if (config_params[i].param_name){
						char *type=NULL;
						type = config_type(&config_params[i]);
						if (!strcmp(type,"unknown")){
							/*error doesn't exists this param_name */
							if (cnt[0]->conf.control_html_output){
								response_client(client_socket,not_found_response_valid_command,NULL);
							}	
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);
							return 1;
						}else{
							value=config_params[i].print(cnt, NULL, i, thread);
							if (value == NULL)
								value=config_params[i].print(cnt, NULL, i, 0);
							if (cnt[0]->conf.control_html_output){
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"<li>%s = %s</li>",config_params[i].param_name,value);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/get><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
							}else{
							send_template_ini_client_raw(client_socket);
							sprintf(res,"%s = %s\n",config_params[i].param_name,value);
							send_template_raw(client_socket,res);
							}
						}
					}else{
						/*error*/
						if (cnt[0]->conf.control_html_output){
							response_client(client_socket,not_found_response_valid_command,NULL);
						}		
						else response_client(client_socket,not_found_response_valid_command_raw,NULL);
					}
				}else{
					/*error*/
					if (cnt[0]->conf.control_html_output){
						response_client(client_socket,not_found_response_valid_command,NULL);
					}	
					else response_client(client_socket,not_found_response_valid_command_raw,NULL);
				}
			}
		}else if(lenght_uri == 0){
			if (cnt[0]->conf.control_html_output){
				send_template_ini_client(client_socket,ini_template);
				sprintf(res,"<b>Thread %d </b><form action=get><select name='query'>",thread);
				send_template(client_socket,res);
				for (i=0; config_params[i].param_name != NULL; i++) {
					sprintf(res,"<option value='%s'>%s</option>",config_params[i].param_name,config_params[i].param_name);
				send_template(client_socket,res);
				}
				sprintf(res,"</select><input type='submit' value='get'></form><a href=/%d/config><- back</a>",thread);
				send_template(client_socket,res);
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				sprintf(res,"get needs param_name\n");
				send_template_raw(client_socket,res);
			}
		}else{	
			/*error*/
			if (cnt[0]->conf.control_html_output)
				response_client(client_socket,not_valid_sintax,NULL);
			else response_client(client_socket,not_valid_sintax_raw,NULL);
		}
	}else if (!strcmp(command,"write")){
			pointer=pointer+5;lenght_uri=lenght_uri-5;
			if (lenght_uri==0){
				if (cnt[0]->conf.control_html_output){
					send_template_ini_client(client_socket,ini_template);
					sprintf(res,"Are you sure ? <a href=/%d/config/writeyes>Yes</a>",thread);
					send_template(client_socket,res);
					sprintf(res,"<a href=/%d/config>No</a>",thread);
					send_template(client_socket,res);
					send_template_end_client(client_socket);
				}else{
					conf_print(cnt);
					send_template_ini_client_raw(client_socket);
					sprintf(res,"Thread %d write done !\n",thread);
					send_template_raw(client_socket,res);
				}
			}else{
				/*error*/
				if (cnt[0]->conf.control_html_output){
					response_client(client_socket,not_found_response_valid_command,NULL);
				}	
				else response_client(client_socket,not_found_response_valid_command_raw,NULL);
			}
	
	}else if (!strcmp(command,"writeyes")){
		pointer=pointer+8;lenght_uri=lenght_uri-8;
		if (lenght_uri==0){
			conf_print(cnt);
			if (cnt[0]->conf.control_html_output){
				send_template_ini_client(client_socket,ini_template);
				sprintf(res,"<b>Thread %d</b> write done !",thread);
				send_template(client_socket,res);
				sprintf(res,"<a href=/%d/config><- back</a>",thread);
				send_template(client_socket,res);
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				sprintf(res,"Thread %d write done !\n",thread);
				send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else{
		/*error*/
		if (cnt[0]->conf.control_html_output){
			response_client(client_socket,not_found_response_valid_command,NULL);
		}	
		else response_client(client_socket,not_found_response_valid_command_raw,NULL);
	}			 
	
	return 1;
}


/*
    This function manages/parses the actions for motion ( makemovie , snapshot , restart , quit ).
*/
 
int action(char *pointer,char *res,int lenght_uri,int thread,int client_socket,void *userdata)
{
	/* parse action commands */
	char *command=NULL;
	struct context **cnt=userdata;		
	sscanf (pointer, "%a[a-z]" , &command);
	if (!strcmp(command,"makemovie")){
		pointer=pointer+9;lenght_uri=lenght_uri-9;
		if (lenght_uri==0){
			/*call makemovie*/

			if (thread==0) {
				int i=0;
				while (cnt[++i])
					cnt[i]->makemovie=1;
			} else {
				cnt[thread]->makemovie=1;
			}
			
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,ini_template);
			sprintf(res,"makemovie for thread %d done",thread);
			send_template(client_socket,res);
			sprintf(res,"<a href=/%d/action><- back</a>",thread);
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			sprintf(res,"makemovie for thread %d done\n",thread);
			send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"snapshot")){
		pointer=pointer+8;lenght_uri=lenght_uri-8;
		if (lenght_uri==0){
			/*call snapshot*/
			
			if (thread==0) {
				int i=0;
				while (cnt[++i])
					cnt[i]->snapshot=1;
			} else {
				cnt[thread]->snapshot=1;
			}
			
			cnt[thread]->snapshot=1;
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,ini_template);
			sprintf(res,"snapshot for thread %d done",thread);
			send_template(client_socket,res);
			sprintf(res,"<a href=/%d/action><- back</a>",thread);
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			sprintf(res,"snapshot for thread %d done\n",thread);
			send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"restart")){	
		pointer=pointer+7;lenght_uri=lenght_uri-7;
		if (lenght_uri==0){
			int i=0;
			do {
				printf("http thread: %d restart\n", i);
				kill(getpid(),1);
				//signal(SIGHUP);
			} while (cnt[++i]);
			if (cnt[0]->conf.control_html_output){	
			send_template_ini_client(client_socket,ini_template);
			res = strdup("restart in progress ... bye");
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			res = strdup("restart in progress ...\n");
			send_template_raw(client_socket,res);
			}
			return 0; // to restart 
		}else{
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"quit")){
		pointer=pointer+4;lenght_uri=lenght_uri-4;
		if (lenght_uri==0){
			int i=0;
			/*call quit*/
			do {
				printf("http thread: %d quitting\n", i);
				cnt[i]->makemovie=1;
				cnt[i]->finish=1;
			} while (cnt[++i]);
			if (cnt[0]->conf.control_html_output){	
			send_template_ini_client(client_socket,ini_template);
			res = strdup("quit in progress ... bye");
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			res = strdup("quit in progress ... bye\n");
			send_template_raw(client_socket,res);
			}
			return 0; // to quit
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else{
		if (cnt[0]->conf.control_html_output){
			response_client(client_socket,not_found_response_valid_command,NULL);
		}	
		else response_client(client_socket,not_found_response_valid_command_raw,NULL);
	}
	
	return 1;
}

/* 
   This function manages/parses the detection actions for motion ( status , start , pause ).
*/

int detection(char *pointer,char *res,int lenght_uri,int thread,int client_socket,void *userdata)
{
	char *command=NULL;
	struct context **cnt=userdata;		
		
	sscanf (pointer, "%a[a-z]" , &command);		
	if (!strcmp(command,"status")){
		pointer=pointer+6;lenght_uri=lenght_uri-6;
		if (lenght_uri==0){
			/*call status*/
			if (cnt[thread]->pause){
				sprintf(res,"Thread %d Detection status PAUSE",thread);
			}else{
				sprintf(res,"Thread %d Detection status ACTIVE",thread);
			}
			if (cnt[0]->conf.control_html_output){
				send_template_ini_client(client_socket,ini_template);
				send_template(client_socket,res);
				sprintf(res,"<a href=/%d/detection><- back</a>",thread);
				send_template(client_socket,res);
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"start")){
		pointer=pointer+5;lenght_uri=lenght_uri-5;
		if (lenght_uri==0){
			/*call start*/
			cnt[thread]->pause=0;
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,ini_template);
			sprintf(res,"Thread %i Detection resumed",thread);
			send_template(client_socket,res);
			sprintf(res,"<a href=/%d/detection><- back</a>",thread);
			send_template(client_socket,res);
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			sprintf(res,"Thread %i Detection resumed\n",thread);
			send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"pause")){
		pointer=pointer+5;lenght_uri=lenght_uri-5;
		if (lenght_uri==0){
			/*call pause*/
			cnt[thread]->pause=1;
			if (cnt[0]->conf.control_html_output){
				send_template_ini_client(client_socket,ini_template);
				sprintf(res,"Thread %i Detection paused",thread);
				send_template(client_socket,res);
				sprintf(res,"<a href=/%d/detection><- back</a>",thread);
				send_template(client_socket,res);
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				sprintf(res,"Thread %i Detection paused\n",thread);
				send_template_raw(client_socket,res);
			}
		}else{
			/*error*/
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else{
		if (cnt[0]->conf.control_html_output){
			response_client(client_socket,not_found_response_valid_command,NULL);
		}	
		else response_client(client_socket,not_found_response_valid_command_raw,NULL);
	}
	
	return 1;
}


/*
   This function manages/parses the track action for motion ( set , pan , tilt , auto ). 
*/

int track(char *pointer,char *res,int lenght_uri,int thread,int client_socket,void *userdata)
{
	char question;
	char *command=NULL;
	struct context **cnt=userdata;		

	sscanf (pointer, "%a[a-z]%c" , &command,&question);
	if (!strcmp(command,"set")){
		pointer=pointer+3;lenght_uri=lenght_uri-3;
		/* FIXME need to check each value */
		/* Relative movement set?pan=0&tilt=0 | set?pan=0 | set?tilt=0*/
		/* Absolute movement set?x=0&y=0 | set?x=0 | set?y=0 */
			
		if ((question == '?') && (lenght_uri>2)){
			char *value1=NULL,*value2=NULL;
			struct context *setcnt;
			int pan=0, tilt=0 ,X=0 , Y=0;

			pointer++;
			lenght_uri--;
			/* set?pan=value&tilt=value */
			/* set?x=value&y=value */
			/* pan= or x= | tilt= or y= */
				
			sscanf (pointer, "%a[a-z]%c" , &command,&question);
			
			if ( question != '=' ){
				/* no valid sintax */
				fprintf(stderr,"http thread debug message: race 1\n");
				if (cnt[0]->conf.control_html_output)
					response_client(client_socket,not_valid_sintax,NULL);
				else
					response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			pointer++;
			lenght_uri--;
				
			/* Check first parameter */
					
			if (!strcmp(command,"pan")){
				pointer=pointer+3;
				lenght_uri=lenght_uri-3;
				pan=1;
			}
			else if (!strcmp(command,"tilt")){
				pointer=pointer+4;
				lenght_uri=lenght_uri-4;
				tilt=1;
			}
			else if	(!strcmp(command,"x")){
				pointer++;
				lenght_uri--;
				X=1;
			}
			else if	(!strcmp(command,"y")){
				pointer++;
				lenght_uri--;
				Y=1;
			}else{
				/* no valid sintax */
				fprintf(stderr,"http thread debug message: race 2\n");
				if (cnt[0]->conf.control_html_output)
					response_client(client_socket,not_valid_sintax,NULL);
				else
					response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
		
			
			/* first value */
			
			sscanf (pointer, "%a[-0-9]" , &value1);
			if (( value1 == NULL ) || ((strlen(value1)) < 1) ){
				fprintf(stderr,"http thread debug message: race 3\n");
				/* no valid sintax */
				if (cnt[0]->conf.control_html_output)
					response_client(client_socket,not_valid_sintax,NULL);
				else
					response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			pointer = pointer + strlen(value1);
			lenght_uri = lenght_uri - strlen(value1);
			
			/* Only one parameter (pan= ,tilt= ,x= ,y= ) */
			if (lenght_uri == 0){
				if (pan){
					struct coord cent;
					struct context *pancnt;		 
					 
					/* move pan */	
				
					pancnt=cnt[thread];
					cent.width=pancnt->imgs.width;
					cent.height=pancnt->imgs.height;
					cent.y=0;	
					cent.x=atoi(value1);
					if (track_move(pancnt, pancnt->video_dev, pancnt->pipe, pancnt->mpipe, &cent, &pancnt->imgs, 1)){
						if (cnt[0]->conf.control_html_output){
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"track set relative pan %s",value1);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
						}else{
							send_template_ini_client_raw(client_socket);	
							sprintf(res,"track set relative pan %s\n",value1);
							send_template_raw(client_socket,res);
						}
					}else{
					/*error in track action*/
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							response_client(client_socket,track_error,res);
						}	
						else response_client(client_socket,track_error_raw,NULL);
					}	
				}else if (tilt){
					struct coord cent;
					struct context *tiltcnt;		 
				
					/* move tilt */
				
					tiltcnt=cnt[thread];
					cent.width=tiltcnt->imgs.width;
					cent.height=tiltcnt->imgs.height;
					cent.x=0;
					cent.y=atoi(value1);
					if (track_move(tiltcnt, tiltcnt->video_dev, tiltcnt->pipe, tiltcnt->mpipe, &cent, &tiltcnt->imgs, 1)){
						if (cnt[0]->conf.control_html_output){
						send_template_ini_client(client_socket,ini_template);
						sprintf(res,"track set relative tilt %s",value1);
						send_template(client_socket,res);
						sprintf(res,"<a href=/%d/track><- back</a>",thread);
						send_template(client_socket,res);
						send_template_end_client(client_socket);
						}else{
						send_template_ini_client_raw(client_socket);	
						sprintf(res,"track set relative tilt %s\n",value1);
						send_template_raw(client_socket,res);
						}							
					}else{
						/*error in track action*/
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							response_client(client_socket,track_error,res);
						}	
						else response_client(client_socket,track_error_raw,NULL);
					}	
				}else if (X){
					/* X */
					setcnt=cnt[thread];
					// 1000 is out of range for pwc 
					if (track_center(setcnt, setcnt->video_dev, 1, atoi(value1), 1000)){
						if (cnt[0]->conf.control_html_output){		
						send_template_ini_client(client_socket,ini_template);
						sprintf(res,"track set absolute x=%s",value1);
						send_template(client_socket,res);
						sprintf(res,"<a href=/%d/track><- back</a>",thread);
						send_template(client_socket,res);
						send_template_end_client(client_socket);
						}else{
						send_template_ini_client_raw(client_socket);
						sprintf(res,"track set absolute x=%s\n",value1);
						send_template_raw(client_socket,res);
						}					
					}else{
						/*error in track action*/
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							response_client(client_socket,track_error,res);
						}	
						else response_client(client_socket,track_error_raw,NULL);
					}	
					
				}else{
					/* Y */
					setcnt=cnt[thread];
					// 1000 is out of range for pwc 
					if (track_center(setcnt, setcnt->video_dev, 1, 1000, atoi(value1))){
						if (cnt[0]->conf.control_html_output){		
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"track set absolute y=%s",value1);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
						}else{
							send_template_ini_client_raw(client_socket);
							sprintf(res,"track set absolute y=%s\n",value1);
							send_template_raw(client_socket,res);
						}					
					}else{
						/*error in track action*/
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							response_client(client_socket,track_error,res);
						}
						else response_client(client_socket,track_error_raw,NULL);
					}	
				}
				return 1;
			}
					
					
			/* Check Second parameter */
				
			sscanf (pointer, "%c%a[a-z]" ,&question, &command);
			if ( question != '&' ){
				fprintf(stderr,"http thread debug message: race 4\n");
				/* no valid sintax */
				if (cnt[0]->conf.control_html_output)
					response_client(client_socket,not_valid_sintax,NULL);
				else response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			pointer++;lenght_uri--;
			
			if (!strcmp(command,"pan")){
				pointer=pointer+3;lenght_uri=lenght_uri-3;
				if ( (pan) || (!tilt) || (X) || (Y) ){
					fprintf(stderr,"race 5\n");
					/* no valid sintax */
					if (cnt[0]->conf.control_html_output)
						response_client(client_socket,not_valid_sintax,NULL);
					else response_client(client_socket,not_valid_sintax_raw,NULL);
					return 1;
				}
				pan=2;
			}
			else if (!strcmp(command,"tilt")){
				pointer=pointer+4;lenght_uri=lenght_uri-4;
				if ( (tilt) || (!pan) || (X) || (Y) ){
					/* no valid sintax */
					fprintf(stderr,"http thread debug message: race 6\n");
					if (cnt[0]->conf.control_html_output)
						response_client(client_socket,not_valid_sintax,NULL);
					else response_client(client_socket,not_valid_sintax_raw,NULL);
					return 1;
				}
				tilt=2;
			}
			else if	(!strcmp(command,"x")){
				pointer++;lenght_uri--;
				if ( (X) || (!Y) || (pan) || (tilt) ){
					fprintf(stderr,"http thread debug message: race 7\n");
					/* no valid sintax */
					if (cnt[0]->conf.control_html_output)
						response_client(client_socket,not_valid_sintax,NULL);
					else response_client(client_socket,not_valid_sintax_raw,NULL);
					return 1;
				}
				X=2;
			}
			else if	(!strcmp(command,"y")){
				pointer++;lenght_uri--;
				if ( (Y) || (!X) || (pan) || (tilt) ){
					fprintf(stderr,"http thread debug message: race 8\n");
					/* no valid sintax */
					if (cnt[0]->conf.control_html_output)
						response_client(client_socket,not_valid_sintax,NULL);
					else response_client(client_socket,not_valid_sintax_raw,NULL);
					return 1;
				}
				Y=2;
			}else{
				fprintf(stderr,"http thread debug message: race 9\n");
				/* no valid sintax */
				if (cnt[0]->conf.control_html_output)
					response_client(client_socket,not_valid_sintax,NULL);
				else response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			/* Second value */
			
			sscanf (pointer, "%c%a[-0-9]" ,&question, &value2);
			if ( ( question != '=' ) || ( value2 == NULL ) || ( (strlen(value2)) < 1) ){
				fprintf(stderr,"http thread debug message: race 10\n");
				/* no valid sintax */
				if (cnt[0]->conf.control_html_output){
					response_client(client_socket,not_valid_sintax,NULL);
				}	
				else response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			pointer = pointer + strlen(value2) + 1;
			lenght_uri = lenght_uri - strlen(value2) - 1;
				
			if (lenght_uri != 0){
				fprintf(stderr,"http thread debug message: race 11\n");
				/* no valid sintax */
				if (cnt[0]->conf.control_html_output){
					response_client(client_socket,not_valid_sintax,NULL);
				}	
				else response_client(client_socket,not_valid_sintax_raw,NULL);
				return 1;
			}
			
			
			/* track set absolute ( x , y )*/
			
			if ( X && Y ){
				setcnt=cnt[thread];
				if (track_center(setcnt, setcnt->video_dev, 1, atoi(value1), atoi(value2))){
					if (cnt[0]->conf.control_html_output){		
						send_template_ini_client(client_socket,ini_template);
						sprintf(res,"track set %s %s",value1,value2);
						send_template(client_socket,res);
						sprintf(res,"<a href=/%d/track><- back</a>",thread);
						send_template(client_socket,res);
						send_template_end_client(client_socket);
					}else{
						send_template_ini_client_raw(client_socket);
						sprintf(res,"track set %s %s\n",value1,value2);
						send_template_raw(client_socket,res);
					}					
				}else{
					/*error in track action*/
					if (cnt[0]->conf.control_html_output){
						sprintf(res,"<a href=/%d/track><- back</a>",thread);
						response_client(client_socket,track_error,res);
					}	
					else response_client(client_socket,track_error_raw,NULL);
				}
				/* track set relative ( pan , tilt )*/
			}else{
				struct coord cent;
				struct context *relativecnt;		 
					 
				/* move pan */	
				
				relativecnt=cnt[thread];
				cent.width=relativecnt->imgs.width;
				cent.height=relativecnt->imgs.height;
				cent.y=0;	
				cent.x=atoi(value1);
				if (track_move(relativecnt, relativecnt->video_dev, relativecnt->pipe, relativecnt->mpipe, &cent, &relativecnt->imgs, 1)){
					/* move tilt */
					relativecnt=cnt[thread];
					cent.width=relativecnt->imgs.width;
					cent.height=relativecnt->imgs.height;
					cent.x=0;
					cent.y=atoi(value2);
					if (track_move(relativecnt, relativecnt->video_dev, relativecnt->pipe, relativecnt->mpipe, &cent, &relativecnt->imgs, 1)){
						if (cnt[0]->conf.control_html_output){
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"track pan %s tilt %s",value1,value2);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
						}else{
							send_template_ini_client_raw(client_socket);	
							sprintf(res,"track pan %s tilt %s\n",value1,value2);
							send_template_raw(client_socket,res);
						}	
						return 1;						
					}						
				}
				
				/*error in track action*/
				if (cnt[0]->conf.control_html_output){
					sprintf(res,"<a href=/%d/track><- back</a>",thread);
					response_client(client_socket,track_error,res);
				}	
				else response_client(client_socket,track_error_raw,NULL);
			}				
		}else if (lenght_uri == 0){
			if (cnt[0]->conf.control_html_output){
			send_template_ini_client(client_socket,ini_template);
			sprintf(res,"<b>Thread %d</b> <form action='set'>Pan<input type=text name='pan' value=''>",thread);
			send_template(client_socket,res);
			sprintf(res,"Tilt<input type=text name='tilt' value=''><input type=submit value='set relative'></form>");
			send_template(client_socket,res);
			sprintf(res,"<form action='set'>X<input type=text name='x' value=''>");
			send_template(client_socket,res);					
			sprintf(res,"Y<input type=text name='y' value=''><input type=submit value='set absolute'></form>");
			send_template(client_socket,res);
			sprintf(res,"<a href=/%d/track><- back</a>",thread);
			send_template(client_socket,res);					
			send_template_end_client(client_socket);
			}else{
			send_template_ini_client_raw(client_socket);
			sprintf(res,"set needs a pan/tilt or x/y values\n");
			send_template_raw(client_socket,res);
			}
		}else{	
			/* error not valid command */
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"status")){
		pointer=pointer+6;lenght_uri=lenght_uri-6;
		if (lenght_uri==0){
			if (cnt[0]->conf.control_html_output){
				if (cnt[thread]->track.active)
					sprintf(res,"<b>Thread %d</b><br>track auto enabled\n",thread);
				else sprintf(res,"<b>Thread %d</b><br>track auto disabled\n",thread);
				send_template_ini_client(client_socket,ini_template);
				send_template(client_socket,res);
				sprintf(res,"<a href=/%d/track><- back</a>",thread);
				send_template(client_socket,res);
				send_template_end_client(client_socket);
			}else{
				if (cnt[thread]->track.active)
					sprintf(res,"Thread %d\n track auto enabled\n",thread);
				else sprintf(res,"Thread %d\n track auto disabled\n",thread);
				send_template_ini_client_raw(client_socket);
				send_template_raw(client_socket,res);
			}
		}else{
			/* error not valid command */
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}
	}else if (!strcmp(command,"auto")){
		pointer=pointer+4;lenght_uri=lenght_uri-4;
		if ((question == '?') && (lenght_uri>0)){
			char *query=NULL;
			pointer++;lenght_uri--;
			/* value= */
				
			sscanf (pointer, "%a[a-z]%c",&query,&question);
			if ((question == '=') && (!strcmp(query,"value")) ){
				pointer=pointer+6;lenght_uri=lenght_uri-6;
				sscanf (pointer, "%a[-0-9a-z]" , &command);
				if ((command!=NULL) && (strlen(command) > 0)){
					struct context *autocnt;		 
					
					/* auto value=0|1|status*/
					
					if (!strcmp(command,"status")){
						if (cnt[0]->conf.control_html_output){
							if (cnt[thread]->track.active)
								sprintf(res,"<b>Thread %d</b><br>track auto enabled\n",thread);
							else sprintf(res,"<b>Thread %d</b><br>track auto disabled\n",thread);
							send_template_ini_client(client_socket,ini_template);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							send_template(client_socket,res);	
							send_template_end_client(client_socket);
						}else{
							if (cnt[thread]->track.active)
								sprintf(res,"Thread %d\n track auto enabled\n",thread);
							else sprintf(res,"Thread %d\n track auto disabled\n",thread);
							send_template_ini_client_raw(client_socket);	
							send_template_raw(client_socket,res);
						}
					}else{
						int active;	
						active=atoi(command);
						if (active > -1 && active < 2){
							autocnt=cnt[thread];
							autocnt->track.active=atoi(command);
							if (cnt[0]->conf.control_html_output){
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"track auto	%s",command);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/track><- back</a>",thread);
							send_template(client_socket,res);	
							send_template_end_client(client_socket);
							}else{
							send_template_ini_client_raw(client_socket);	
							sprintf(res,"track auto %s\n",command);
							send_template_raw(client_socket,res);
							}							
						}else{
							if (cnt[0]->conf.control_html_output){
								response_client(client_socket,not_found_response_valid_command,NULL);
							}
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);
						}								
					}	
				}else{
					if (cnt[0]->conf.control_html_output){
						response_client(client_socket,not_found_response_valid_command,NULL);
					}
					else response_client(client_socket,not_found_response_valid_command_raw,NULL);
				}
			}else{
				if (cnt[0]->conf.control_html_output){
					response_client(client_socket,not_found_response_valid_command,NULL);
				}	
				else response_client(client_socket,not_found_response_valid_command_raw,NULL);
			}
		}	
		else if (lenght_uri == 0){
			if (cnt[0]->conf.control_html_output){
				send_template_ini_client(client_socket,ini_template);
				sprintf(res,"<b>Thread %d</b> <form action='auto'><select name='value'>",thread);
				send_template(client_socket,res);
				sprintf(res,"<option value='0'>Disable</option><option value='1'>Enable</option><option value='status'>status</option>");	
				send_template(client_socket,res);
				sprintf(res,"</select><input type=submit value='set'></form>");
				send_template(client_socket,res);
				sprintf(res,"<a href=/%d/track><- back</a>",thread);
				send_template(client_socket,res);	
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);	
				sprintf(res,"auto needs a value 0,1 or status\n");
				send_template_raw(client_socket,res);	
			}
		}else{
			if (cnt[0]->conf.control_html_output){
				response_client(client_socket,not_found_response_valid_command,NULL);
			}	
			else response_client(client_socket,not_found_response_valid_command_raw,NULL);
		}				
	}else{
		if (cnt[0]->conf.control_html_output){
			response_client(client_socket,not_found_response_valid_command,NULL);
		}	
		else response_client(client_socket,not_found_response_valid_command_raw,NULL);
	}
		
	return 1;
}



/*
	parses the action requested for motion ( config , action , detection , track ) and call
	to action function if needed.  
*/

int handle_get (int client_socket, const char* url, void *userdata)
{
	struct context **cnt=userdata;
	if (*url == '/' ){
		int i=0;
		char *res=NULL;	 
		res = malloc(300);

		/* get the number of threads */
		while (cnt[++i]);
		//printf("URL requested %s\n",url);
		/* ROOT_URI -> GET / */
		if (! (strcmp (url, "/")) ){
			int y=0;
			if (cnt[0]->conf.control_html_output){ 
				send_template_ini_client(client_socket,ini_template);
				sprintf(res,"<b>Motion Running [%d] Threads</b>",i);
				send_template(client_socket,res);
				send_template(client_socket,"<a href='/0/'>All</a>");
				for (y=1;y<i;y++){	
					sprintf(res,"<a href='/%d/'>Thread %d</a>",y,y);
					send_template(client_socket,res);
				}	
				send_template_end_client(client_socket);
			}else{
				send_template_ini_client_raw(client_socket);
				sprintf(res,"Motion Running [%d] Threads\n",i);
				send_template_raw(client_socket,res);
				sprintf(res,"Thread 0\n");
				send_template_raw(client_socket,res);
				for (y=1;y<i;y++){	
					sprintf(res,"Thread %d\n",y);
					send_template_raw(client_socket,res);
				}	
			}				
		}
		else{
			char *command=NULL;
			char slash;
			int thread=-1;
			int lenght_uri=0;
			char *pointer=(char *)url;

			lenght_uri = strlen(url);	  
			/* Check for Thread number first -> GET /2 */
			pointer++;
			lenght_uri--;
			sscanf (pointer, "%i%c", &thread,&slash);
			
			if ((thread != -1) && (thread < i)){
				/* thread_number found */      
				if (slash == '/') {   /* slash found /2/ */
					pointer = pointer+2;lenght_uri=lenght_uri-2;
				} else {
					pointer++;    /* /2 found */
					lenght_uri--; 
				}

				if (lenght_uri!=0){ 	 
					sscanf (pointer, "%a[a-z]%c" , &command , &slash);	

					/* config */
					if (!strcmp(command,"config")){
						pointer = pointer + 6;lenght_uri = lenght_uri - 6;
						if (lenght_uri == 0){
							if (cnt[0]->conf.control_html_output){
							send_template_ini_client(client_socket,ini_template);
							sprintf(res,"<b>Thread %d</b>",thread);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/list>list</a>",thread);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/write>write</a>",thread);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/set>set</a>",thread);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/config/get>get</a>",thread);
							send_template(client_socket,res);
							sprintf(res,"<a href=/%d/><- back</a>",thread);
							send_template(client_socket,res);
							send_template_end_client(client_socket);
							}else{
							send_template_ini_client_raw(client_socket);
							sprintf(res,"Thread %d\n",thread);
							send_template_raw(client_socket,res);
							sprintf(res,"list\n");
							send_template_raw(client_socket,res);
							sprintf(res,"write\n");
							send_template_raw(client_socket,res);
							sprintf(res,"set\n");
							send_template_raw(client_socket,res);
							sprintf(res,"get\n");
							send_template_raw(client_socket,res);
							}								
						}else if ((slash == '/') && (lenght_uri >= 4)){
							/*call config() */
							pointer++;lenght_uri--;
							config(pointer,res,lenght_uri,thread,client_socket,cnt);
						}else{
							if (cnt[0]->conf.control_html_output){
								response_client(client_socket,not_found_response_valid_command,NULL);
							}
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);
						}							
					}	
					/* action */
					else if (!strcmp(command,"action")){
						pointer = pointer + 6;lenght_uri = lenght_uri - 6;
						/* call action() */
						if (lenght_uri == 0){
							if (cnt[0]->conf.control_html_output){
								send_template_ini_client(client_socket,ini_template);
								sprintf(res,"<b>Thread %d</b>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/action/makemovie>makemovie</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/action/snapshot>snapshot</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/action/restart>restart</a>",thread);
								send_template(client_socket,res);	
								sprintf(res,"<a href=/%d/action/quit>quit</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/><- back</a>",thread);
								send_template(client_socket,res);
								send_template_end_client(client_socket);
							}else{
								send_template_ini_client_raw(client_socket);	
								sprintf(res,"Thread %d\n",thread);
								send_template_raw(client_socket,res);
								sprintf(res,"makemovie\n");
								send_template_raw(client_socket,res);
								sprintf(res,"snapshot\n");
								send_template_raw(client_socket,res);
								sprintf(res,"restart\n");
								send_template_raw(client_socket,res);	
								sprintf(res,"quit\n");
								send_template_raw(client_socket,res);
							}								
						}else if ((slash == '/') && (lenght_uri > 4)){
							int ret=1;
							pointer++;lenght_uri--;
							ret=action(pointer,res,lenght_uri,thread,client_socket,cnt);
							free(res);
							return ret;
							
						}else{
							if (cnt[0]->conf.control_html_output){
								response_client(client_socket,not_found_response_valid_command,NULL);
							}		
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);
						}							
					}
					/* detection */
					else if (!strcmp(command,"detection")){
						pointer = pointer + 9;lenght_uri = lenght_uri - 9;
						if (lenght_uri == 0){
							if (cnt[0]->conf.control_html_output){
								send_template_ini_client(client_socket,ini_template);
								sprintf(res,"<b>Thread %d</b>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/detection/status>status</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/detection/start>start</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/detection/pause>pause</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/><- back</a>",thread);
								send_template(client_socket,res);
								send_template_end_client(client_socket);
							}else{
								send_template_ini_client_raw(client_socket);
								sprintf(res,"Thread %d\n",thread);
								send_template_raw(client_socket,res);
								sprintf(res,"status\n");
								send_template_raw(client_socket,res);
								sprintf(res,"start\n");
								send_template_raw(client_socket,res);
								sprintf(res,"pause\n");
								send_template_raw(client_socket,res);
							}								
						}else if ((slash == '/') && (lenght_uri > 5)){
							pointer++;lenght_uri--;
							/* call detection() */
							detection(pointer,res,lenght_uri,thread,client_socket,cnt);
						}else{
							if (cnt[0]->conf.control_html_output){
								response_client(client_socket,not_found_response_valid_command,NULL);
							}		
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);
						}							
					}
					/* track */
					else if(!strcmp(command,"track")){
						pointer = pointer + 5;lenght_uri = lenght_uri - 5;
						if (lenght_uri == 0){
							if (cnt[0]->conf.control_html_output){
								send_template_ini_client(client_socket,ini_template);
								sprintf(res,"<b>Thread %d</b>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/track/set>track set pan/tilt</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/track/auto>track auto</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/track/status>track status</a>",thread);
								send_template(client_socket,res);
								sprintf(res,"<a href=/%d/><- back</a>",thread);
								send_template(client_socket,res);
								send_template_end_client(client_socket);
							}else{
								send_template_ini_client_raw(client_socket);
								sprintf(res,"Thread %d\n",thread);
								send_template_raw(client_socket,res);
								sprintf(res,"set pan/tilt\n");
								send_template_raw(client_socket,res);
								sprintf(res,"auto\n");
								send_template_raw(client_socket,res);	
								sprintf(res,"status\n");
								send_template_raw(client_socket,res);	
							}
						}
						else if ((slash == '/') && (lenght_uri >= 4)){
							pointer++;lenght_uri--;
							/* call track() */
							if (cnt[thread]->track.type){
								track(pointer,res,lenght_uri,thread,client_socket,cnt);
							}else{
								/* error track not enable */
								if (cnt[0]->conf.control_html_output){
									sprintf(res,"<a href=/%d/><- back</a>",thread);
									response_client(client_socket,not_track,res);
								}	
								else response_client(client_socket,not_track_raw,NULL);
							}								
						}else{
							if (cnt[0]->conf.control_html_output){
								sprintf(res,"<a href=/%d/><- back</a>",thread);
								response_client(client_socket,not_found_response_valid_command,res);
							}	
							else response_client(client_socket,not_found_response_valid_command_raw,NULL);						}								
					}else{
						if (cnt[0]->conf.control_html_output){
							sprintf(res,"<a href=/%d/><- back</a>",thread);
							response_client(client_socket,not_found_response_valid_command,res);
						}	
						else response_client(client_socket,not_found_response_valid_command_raw,NULL);
					}
				}else{
					/* /thread_number/ requested */
					if (cnt[0]->conf.control_html_output){
						send_template_ini_client(client_socket,ini_template);
						sprintf(res,"<b>Thread %d</b>",thread);
						send_template(client_socket,res);
						sprintf(res,"<a href='/%d/config'>config</a>",thread);
						send_template(client_socket,res);
						sprintf(res,"<a href='/%d/action'>action</a>",thread);
						send_template(client_socket,res);
						sprintf(res,"<a href='/%d/detection'>detection</a>",thread);
						send_template(client_socket,res);
						sprintf(res,"<a href='/%d/track'>track</a>",thread);
						send_template(client_socket,res);  
						sprintf(res,"<a href=/><- back</a>");
						send_template(client_socket,res);  
						send_template_end_client(client_socket);
					}else{
						send_template_ini_client_raw(client_socket);	
						sprintf(res,"Thread %d\n",thread);
						send_template_raw(client_socket,res);
						sprintf(res,"config\n");
						send_template_raw(client_socket,res);
						sprintf(res,"action\n");
						send_template_raw(client_socket,res);
						sprintf(res,"detection\n");
						send_template_raw(client_socket,res);
						sprintf(res,"track\n");
						send_template_raw(client_socket,res);
					}						
				}
			}else{
				if (cnt[0]->conf.control_html_output){
					sprintf(res,"<a href=/%d/><- back</a>",thread);
					response_client(client_socket,not_found_response_valid,res);
				}	
				else response_client(client_socket,not_found_response_valid_raw,NULL);
			}
		}
		free(res);
	}else{
		if (cnt[0]->conf.control_html_output){
			response_client(client_socket,not_found_response_template,NULL);
		}	
		else response_client(client_socket,not_found_response_template_raw,NULL);
	}

	return 1;
}


/*
 -TODO-
 As usually web clients uses nonblocking connect/read
 read_client should handle nonblocking sockets.
*/

int read_client (int client_socket,void *userdata,char *auth)
{
	int alive=1;
	int ret=1;
	char buffer[1024]={'\0'};
	int length=1024;
	struct context **cnt=userdata;

	/* lock the mutex */
	pthread_mutex_lock(&httpd_mutex);

	while (alive) 
	{
		int nread=0;

		nread = read (client_socket, buffer, length);

		if (nread <= 0){
			printf("motion-httpd: First read [%s] [%i]\n",strerror(errno),errno);
			pthread_mutex_unlock(&httpd_mutex);
			return -1;
		}
		else{
			char method[sizeof (buffer)];
			char url[sizeof (buffer)];
			char protocol[sizeof (buffer)];
			char *authentication=NULL;

			buffer[nread] = '\0';

			sscanf (buffer, "%s %s %s", method, url, protocol);	
		
			while (strstr (buffer, "\r\n\r\n") == NULL){
				nread =+ read (client_socket, buffer, sizeof (buffer));
				if (nread <= 0){
					printf("motion-httpd: Waiting for Buffer ending [%s] [%i]\n",strerror(errno),errno);
					break;
				}
				buffer[nread] = '\0';
			}

			/* Make sure the last read didn't fail.  If it did, there's a
			problem with the connection, so give up.  */
			if (nread == -1) {
				printf("motion-httpd: Read -1 [%s] [%i]\n",strerror(errno),errno);
				pthread_mutex_unlock(&httpd_mutex);
				return -1;
			}
			alive=0;

			/* Check Protocol */
			if (strcmp (protocol, "HTTP/1.0") && strcmp (protocol, "HTTP/1.1")) {
				/* We don't understand this protocol.  Report a bad response.  */
				if (cnt[0]->conf.control_html_output)
					write (client_socket, bad_request_response, sizeof (bad_request_response));
				else
					write (client_socket, bad_request_response_raw, sizeof (bad_request_response_raw));
				pthread_mutex_unlock(&httpd_mutex);
				return -1;
			}
			else if (strcmp (method, "GET")) {
				/* This server only implements the GET method.  If client
				uses other method, report the failure.  */
				char response[1024];
				if (cnt[0]->conf.control_html_output)
					snprintf (response, sizeof (response),bad_method_response_template, method);
				else
					snprintf (response, sizeof (response),bad_method_response_template_raw, method);
				write (client_socket, response, strlen (response));
				pthread_mutex_unlock(&httpd_mutex);
				return -1;
			} else if ( auth != NULL) {
				if ( (authentication = strstr(buffer,"Basic")) ) 
				{
					char *end_auth=NULL;
					authentication = authentication + 6;
					
					if ( (end_auth  = strstr(authentication,"\r\n")) )
					{
						authentication[end_auth - authentication] = '\0';
					}else{
						char response[1024];
						snprintf (response, sizeof (response),request_auth_response_template, method);
						write (client_socket, response, strlen (response));
						pthread_mutex_unlock(&httpd_mutex);
						return -1;
					}
					
					if ( !check_authentication(auth,authentication,strlen(cnt[0]->conf.control_authentication),cnt[0]->conf.control_authentication) )  {
						char response[1024];
						snprintf (response, sizeof (response),request_auth_response_template, method);
						write (client_socket, response, strlen (response));
						pthread_mutex_unlock(&httpd_mutex);
						return -1;
					}else{
						ret=handle_get (client_socket, url,cnt);
			  			/* A valid auth request.  Process it.  */
			       		}
				}	
				else
				{ 
					// Resquest Authorithation
					char response[1024];
					snprintf (response, sizeof (response),request_auth_response_template, method);
					write (client_socket, response, strlen (response));
					pthread_mutex_unlock(&httpd_mutex);
					return -1;
				}	
			} else { 
				ret=handle_get (client_socket, url,cnt);
				/* A valid request.  Process it.  */
			}
		}
	}
	pthread_mutex_unlock(&httpd_mutex);
	
	return ret;
}


/*
   Main function: Create the listening socket and waits client requests.
*/

void httpd_run(struct context **cnt)
{
	
	int sd, client_socket_fd;
	int cliLen, client_sent_quit_message=1 , val=1;
	char *authentication=NULL;
	struct sockaddr_in cliAddr, servAddr;
	
	/* Initialize the mutex */
	pthread_mutex_init(&httpd_mutex, NULL);

	/* create socket */
	sd = socket(AF_INET, SOCK_STREAM, 0);
	if (sd<0) {
		perror("motion-httpd: cannot open socket ");
		return; 
	}
	
	/* bind server port */
	servAddr.sin_family = AF_INET;
	if (cnt[0]->conf.control_localhost)
		servAddr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
	else servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
	servAddr.sin_port = htons(cnt[0]->conf.control_port);
 
	// Reuse address :-P
	setsockopt( sd,SOL_SOCKET,SO_REUSEADDR, &val, sizeof( int ) ) ;

	if (bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr))<0) {
		perror("motion-httpd: httpd cannot bind port ");
		close(sd);
		return ;
	}

	listen(sd,5);

	{
		const char msg[]="motion-httpd running, accepting connections";
		printf("%s\n", msg);
		syslog(LOG_DEBUG, "%s", msg);
	}

	printf("motion-httpd: waiting for data on port TCP %d\n",cnt[0]->conf.control_port);

	 if (cnt[0]->conf.control_authentication != NULL ) {
		char *userpass = NULL;
		size_t auth_size = strlen(cnt[0]->conf.control_authentication);
		
		authentication = (char *) mymalloc(BASE64_LENGTH(auth_size) + 1);
		userpass = mymalloc(auth_size + 4);
		/* base64_encode can read 3 bytes after the end of the string, initialize it */
		memset(userpass, 0, auth_size + 4);
		strcpy(userpass, cnt[0]->conf.control_authentication);
		base64_encode(userpass, authentication, auth_size);
		free(userpass);
	} 
		
	while(client_sent_quit_message!=0) { // Hey Change that condiction
	
		cliLen = sizeof(cliAddr);			
		client_socket_fd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);
		
		if(client_socket_fd<0) {
			perror("motion-httpd: cannot accept connection ");
			//return ;
		} else {
			/* Get the Client request */
			if ( (client_sent_quit_message = read_client (client_socket_fd,cnt,authentication)) != -1)
			{
				printf("motion-httpd: Read from client - Success\n");
			} else { 
				fprintf(stderr,"motion-httpd: Read from client - Error\n");
			}
			/* Close Connection */
			if (client_socket_fd)
				close(client_socket_fd);
		}
		
	}

	if (authentication != NULL) free(authentication);
	close(sd);
	fprintf(stderr,"motion-httpd: Closing httpd\n");
}


void * motion_web_control(void *arg)
{
	struct context **cnt=arg;
	httpd_run(cnt);	
	return 0;
}
