/* 
 * GSturl
 * Copyright (C) 2005 Vincenzo Di Massa <hawk.it@tiscali.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_URLSRC_H__
#define __GST_URLSRC_H__

#include <gst/gst.h>

G_BEGIN_DECLS

/* #define's don't like whitespacey bits */
#define GST_TYPE_URLSRC \
  (gst_gst_urlsrc_get_type())
#define GST_URLSRC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_URLSRC,GstUrlsrc))
#define GST_URLSRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_URLSRC,GstUrlsrc))
#define GST_IS_URLSRC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_URLSRC))
#define GST_IS_URLSRC_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_URLSRC))

typedef struct _GstUrlsrc      GstUrlsrc;
typedef struct _GstUrlsrcClass GstUrlsrcClass;

typedef enum {
  GST_URLSRC_OPEN              = GST_ELEMENT_FLAG_LAST,

  GST_URLSRC_FLAG_LAST = GST_ELEMENT_FLAG_LAST + 2
} GstUrlsrcFlags;

struct _GstUrlsrc
{
  GstElement element;

  GstPad *srcpad;
  
  CURL *curl;
  
  guint64 sent_bytes;
  gint need_discont;
  gboolean need_flush;

  gchar* url;
  GstClockTime time_start;
  
};

struct _GstUrlsrcClass 
{
  GstElementClass parent_class;
};

GType gst_gst_urlsrc_get_type (void);

G_END_DECLS

#endif /* __GST_URLSRC_H__ */
